using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.OleDb;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Web.Security;
using System.Xml;

public class Default : System.Web.UI.Page
{

protected System.Web.UI.WebControls.Label lblName;

void Page_Load(Object sender , EventArgs e) 
{
FormsIdentity objUserIdentity;
objUserIdentity = (FormsIdentity)User.Identity;
lblName.Text = objUserIdentity.Name.ToString();
}

}

public class AddNews : System.Web.UI.Page
{

protected System.Web.UI.WebControls.TextBox ArticleName;
protected System.Web.UI.WebControls.TextBox ArticleContent;
protected System.Web.UI.WebControls.Button dbButton;
protected System.Web.UI.WebControls.DropDownList Hidden;
protected System.Web.UI.WebControls.DropDownList Comments;
protected System.Web.UI.WebControls.DropDownList Category;


void Page_Load( Object sender, EventArgs e ) {
	if (! IsPostBack )
	{
		BindCategoryList();
	}
	
}

void BindCategoryList (){

	DataSet objCategory = new DataSet();
	objCategory.ReadXml(MapPath("../category.xml"));

    Category.DataSource = objCategory;
    Category.DataTextField = "Category";
    Category.DataValueField = "Category";
    Category.DataBind();
}




public void AddButton_Click(Object sender , EventArgs e) 
{
OleDbConnection conNewsData = new OleDbConnection( "PROVIDER=Microsoft.Jet.OLEDB.4.0;DATA Source=" + Server.MapPath("../NewsData.mdb") );
string strInsert;
DateTime Timestamp;
OleDbCommand cmdInsert;
string timeData;
string artName;
string artContent;
string artUserName;
string artId;
string artHidden;
string artLastComment;
string artCategory;
string artCommentProtection;
int artComments = 0;
FormsIdentity objUserIdentity;
objUserIdentity = (FormsIdentity)User.Identity;


Timestamp = DateTime.Now;
timeData = Timestamp.ToString( "G" ) + " CST";
artName = ArticleName.Text;
artContent = ArticleContent.Text;
artUserName = objUserIdentity.Name.ToString();
artHidden = Hidden.SelectedItem.Text.ToString();
artCategory = Category.SelectedItem.Text.ToString();
artCommentProtection = Comments.SelectedItem.Text.ToString();


		string MaxArticle = "SELECT MAX(ArticleId) from ArticleData";
		DataSet ArticleDS = new DataSet();
		OleDbCommand cmdArticleId = new OleDbCommand( MaxArticle, conNewsData );
		OleDbDataAdapter adpSelectMax = new OleDbDataAdapter();
		adpSelectMax.SelectCommand = cmdArticleId;
	 	adpSelectMax.Fill( ArticleDS, "ArticleData" );
		conNewsData.Open();
		Object objMax = cmdArticleId.ExecuteScalar();
		if (objMax != DBNull.Value) {
			int intMax = Convert.ToInt32(objMax);
			artId = (intMax + 1).ToString();
			}
		else {
			artId = "1"; 
			}
			
		conNewsData.Close();

artLastComment = "<a class='ContentFooter' href='./Comments.aspx?ArticleId=" + artId + "&amp;ArticleName=" + ArticleName.Text + "'>Be the First to Submit a Comment</a>";

strInsert = "Insert Into ArticleData ( ArticleDate, ArticleName, ArticleContent, ArticleUserName, ArticleId, Hidden, ArticleComments, LastComment, Category, CommentProtection ) Values (@timeData, @artName, @artContent, @UserName, @artId, @artHidden, @artComments, @artLasComment, @artCategory, @artCommentProtection)";
cmdInsert = new OleDbCommand( strInsert, conNewsData );
cmdInsert.Parameters.Add( "@timeData", timeData );
cmdInsert.Parameters.Add( "@artName", artName );
cmdInsert.Parameters.Add( "@artContent", artContent );
cmdInsert.Parameters.Add( "@artUserName", artUserName );
cmdInsert.Parameters.Add( "@artId", artId );
cmdInsert.Parameters.Add( "@artHidden", artHidden );
cmdInsert.Parameters.Add( "@artComments", artComments);
cmdInsert.Parameters.Add( "@artLastComment", artLastComment);
cmdInsert.Parameters.Add( "@artCategory", artCategory);
cmdInsert.Parameters.Add( "@artCommentProtection", artCommentProtection);
conNewsData.Open();
cmdInsert.ExecuteNonQuery();
conNewsData.Close();
Response.Redirect( "./" );
}

public void PreviewButton_Click(Object sender , EventArgs e) 
{

}

}

public class EditNews : System.Web.UI.Page
{

protected System.Web.UI.WebControls.DropDownList DBAction;
protected System.Web.UI.WebControls.Button Go;
protected System.Web.UI.WebControls.DataGrid Content;
protected System.Web.UI.WebControls.CheckBox Select;
protected System.Web.UI.WebControls.Panel List;
protected System.Web.UI.WebControls.Panel Edit;


void Page_Load( Object sender, EventArgs e ) {
	if (! IsPostBack )
	{
		BindDataGrid();
	}
	
}
	
void BindDataGrid (){
OleDbConnection conNewsData;
OleDbCommand cmdSelectDB;
OleDbDataReader dtrArticleData;

conNewsData = new OleDbConnection( "PROVIDER=Microsoft.Jet.OLEDB.4.0;DATA Source=" + Server.MapPath("../NewsData.mdb") );
conNewsData.Open();
cmdSelectDB = new OleDbCommand( "Select * From ArticleData ORDER BY ArticleId DESC", conNewsData );
dtrArticleData = cmdSelectDB.ExecuteReader();
Content.DataSource = dtrArticleData;  
Content.DataBind(); 
conNewsData.Close();
}

public void GoButton_Click(Object sender , EventArgs e) 
{		
		string SelectedAction = DBAction.SelectedItem.Text.ToString();
		OleDbConnection conNewsData;
		OleDbCommand cmdDeleteDB;
		string strDelete = "";
						
		foreach (DataGridItem chkboxDataGridItem in Content.Items) {
   			System.Web.UI.WebControls.CheckBox slctCheckBox = (CheckBox)chkboxDataGridItem.FindControl("Select");
				if (slctCheckBox.Checked & SelectedAction=="Delete") {
				string strArticleId = ((Label)(chkboxDataGridItem.FindControl("hdnArticleId"))).Text;
					conNewsData = new OleDbConnection( "PROVIDER=Microsoft.Jet.OLEDB.4.0;DATA Source=" + Server.MapPath("../NewsData.mdb") );
						strDelete = "Delete from ArticleData WHERE ArticleId = @ArticleName";
						cmdDeleteDB = new OleDbCommand( strDelete, conNewsData );
						cmdDeleteDB.Parameters.Add(new OleDbParameter("@ArticleId",  strArticleId));
						conNewsData.Open();
						cmdDeleteDB.ExecuteNonQuery();
						conNewsData.Close();
				}
				else if (slctCheckBox.Checked & SelectedAction=="Hide") {
				string strArticleId = ((Label)(chkboxDataGridItem.FindControl("hdnArticleId"))).Text;
					conNewsData = new OleDbConnection( "PROVIDER=Microsoft.Jet.OLEDB.4.0;DATA Source=" + Server.MapPath("../NewsData.mdb") );
						strDelete = "UPDATE ArticleData SET Hidden = 'Yes' WHERE ArticleId = @ArticleName";
						cmdDeleteDB = new OleDbCommand( strDelete, conNewsData );
						cmdDeleteDB.Parameters.Add(new OleDbParameter("@ArticleId",  strArticleId));
						conNewsData.Open();
						cmdDeleteDB.ExecuteNonQuery();
						conNewsData.Close();
				}
				else if (slctCheckBox.Checked & SelectedAction=="Show") {
				string strArticleId = ((Label)(chkboxDataGridItem.FindControl("hdnArticleId"))).Text;
					conNewsData = new OleDbConnection( "PROVIDER=Microsoft.Jet.OLEDB.4.0;DATA Source=" + Server.MapPath("../NewsData.mdb") );
						strDelete = "UPDATE ArticleData SET Hidden = 'No' WHERE ArticleId = @ArticleName";
						cmdDeleteDB = new OleDbCommand( strDelete, conNewsData );
						cmdDeleteDB.Parameters.Add(new OleDbParameter("@ArticleId",  strArticleId));
						conNewsData.Open();
						cmdDeleteDB.ExecuteNonQuery();
						conNewsData.Close();
				}
				
				
        }
		Response.Redirect(Request.UrlReferrer.ToString());
}  

}

public class Options : System.Web.UI.Page
{

}

public class Help : System.Web.UI.Page
{

}

public class EditArticle : System.Web.UI.Page
{

protected System.Web.UI.WebControls.Button UpdateButton;
protected System.Web.UI.WebControls.Button PreviewButton;
protected System.Web.UI.WebControls.DropDownList DBAction;
protected System.Web.UI.WebControls.Button Go;
protected System.Web.UI.WebControls.DataGrid Content;
protected System.Web.UI.WebControls.Repeater ArticleRepeater;
protected System.Web.UI.WebControls.CheckBox Select;
protected System.Web.UI.WebControls.TextBox ArticleName;
protected System.Web.UI.WebControls.TextBox ArticleContent;
protected System.Web.UI.WebControls.DropDownList Hidden;
protected System.Web.UI.WebControls.DropDownList Comments;
protected System.Web.UI.WebControls.DropDownList Category;


public void UpdateButton_Click(Object sender , EventArgs e) 
{		

		string artHidden = Hidden.SelectedItem.Text.ToString();
		string artCategory = Category.SelectedItem.Text.ToString();
		string artCommentProtection = Comments.SelectedItem.Text.ToString();
		OleDbConnection conNewsData = new OleDbConnection( "PROVIDER=Microsoft.Jet.OLEDB.4.0;DATA Source=" + Server.MapPath("../NewsData.mdb") );
		string strUpdate = "UPDATE ArticleData SET ArticleName = @ArticleName, ArticleContent = @ArticleContent,  Hidden = @ArticleHidden, Category = @ArticleCategory, CommentProtection = @ArticleCommentProtection WHERE ArticleId = @ArticleID";
		OleDbCommand cmdUpdateDB = new OleDbCommand(strUpdate, conNewsData);
		cmdUpdateDB.Parameters.Add(new OleDbParameter("@ArticleName", ArticleName.Text));
		cmdUpdateDB.Parameters.Add(new OleDbParameter("@ArticleContent", ArticleContent.Text));
		cmdUpdateDB.Parameters.Add(new OleDbParameter("@ArticleHidden", artHidden));
		cmdUpdateDB.Parameters.Add(new OleDbParameter("@ArticleCategory", artCategory));
		cmdUpdateDB.Parameters.Add(new OleDbParameter("@ArticleCommenntProtection", artCommentProtection));		
		cmdUpdateDB.Parameters.Add(new OleDbParameter("@ArticleID", Request.QueryString.Get("Edit")));
		conNewsData.Open();
		cmdUpdateDB.ExecuteNonQuery();
		conNewsData.Close();
		
		Response.Redirect("editnews.aspx");
}

public void PreviewButton_Click(Object sender , EventArgs e) 
{

}

void Page_Load( Object sender, EventArgs e ) {
	if (! IsPostBack )
	{
		BindDataGrid();
		BindCategoryList();
		BindTextBox();
		BindDropDownLists();
	}
			
}
	
void BindDataGrid (){
OleDbConnection conNewsData;
OleDbCommand cmdSelectCommentDB;
OleDbDataReader dtrCommentData;

conNewsData = new OleDbConnection( "PROVIDER=Microsoft.Jet.OLEDB.4.0;DATA Source=" + Server.MapPath("../NewsData.mdb") );
conNewsData.Open();
cmdSelectCommentDB = new OleDbCommand( "Select * From CommentData Where CommentId = @ArticleId ORDER BY CommentNumber ASC", conNewsData );
cmdSelectCommentDB.Parameters.Add(new OleDbParameter("@ArticleId", Request.QueryString.Get("Edit")));
dtrCommentData = cmdSelectCommentDB.ExecuteReader();
Content.DataSource = dtrCommentData;  
Content.DataBind(); 
conNewsData.Close();
}

void BindCategoryList (){

	DataSet objCategory = new DataSet();
	objCategory.ReadXml(MapPath("../category.xml"));

    Category.DataSource = objCategory;
    Category.DataTextField = "Category";
    Category.DataValueField = "Category";
    Category.DataBind();
}

void BindTextBox (){
OleDbConnection conNewsData;
OleDbCommand cmdSelectArticleDB;
OleDbDataReader dtrArticleData;

conNewsData = new OleDbConnection( "PROVIDER=Microsoft.Jet.OLEDB.4.0;DATA Source=" + Server.MapPath("../NewsData.mdb") );
conNewsData.Open();
string ArticleSelect = "Select * From ArticleData Where ArticleId = @ArticleId";
cmdSelectArticleDB = new OleDbCommand( ArticleSelect, conNewsData );
cmdSelectArticleDB.Parameters.Add(new OleDbParameter("@ArticleId", Request.QueryString.Get("Edit")));
dtrArticleData = cmdSelectArticleDB.ExecuteReader();
dtrArticleData.Read();
ArticleName.Text = dtrArticleData["ArticleName"].ToString();
ArticleContent.Text = dtrArticleData["ArticleContent"].ToString(); 
dtrArticleData.Close(); 
conNewsData.Close();
}

void BindDropDownLists (){
OleDbConnection conNewsData;
OleDbCommand cmdSelectArticleDB;
OleDbDataReader dtrArticleData;

conNewsData = new OleDbConnection( "PROVIDER=Microsoft.Jet.OLEDB.4.0;DATA Source=" + Server.MapPath("../NewsData.mdb") );
conNewsData.Open();
string ArticleSelect = "Select * From ArticleData Where ArticleId = @ArticleId";
cmdSelectArticleDB = new OleDbCommand( ArticleSelect, conNewsData );
cmdSelectArticleDB.Parameters.Add(new OleDbParameter("@ArticleId", Request.QueryString.Get("Edit")));
dtrArticleData = cmdSelectArticleDB.ExecuteReader();
dtrArticleData.Read();
Hidden.SelectedValue = dtrArticleData["Hidden"].ToString();
Comments.SelectedValue = dtrArticleData["CommentProtection"].ToString();
Category.SelectedValue = dtrArticleData["Category"].ToString();
dtrArticleData.Close(); 
conNewsData.Close();

}

		
public void GoButton_Click(Object sender , EventArgs e) 
{		
		string SelectedAction = DBAction.SelectedItem.Text.ToString();
		OleDbConnection conNewsData;
		OleDbCommand cmdDeleteDB;
		string strDelete = "";
		string artLastUser = "";
		string comNumber;
		string artName;
		string comTotal;
						
		foreach (DataGridItem chkboxDataGridItem in Content.Items) {
   			System.Web.UI.WebControls.CheckBox slctCheckBox = (CheckBox)chkboxDataGridItem.FindControl("Select");
				if (slctCheckBox.Checked & SelectedAction=="Delete") {
				string strCommentNumber = ((Label)(chkboxDataGridItem.FindControl("hdnCommentNumber"))).Text;
					conNewsData = new OleDbConnection( "PROVIDER=Microsoft.Jet.OLEDB.4.0;DATA Source=" + Server.MapPath("../NewsData.mdb") );
						strDelete = "Delete From CommentData Where CommentNumber = @CommentNumber AND CommentId = @CommentId";
						cmdDeleteDB = new OleDbCommand( strDelete, conNewsData );
						cmdDeleteDB.Parameters.Add(new OleDbParameter("@CommentNumber", strCommentNumber));
						cmdDeleteDB.Parameters.Add(new OleDbParameter("@CommentId", Request.QueryString.Get("Edit")));
						conNewsData.Open();
						cmdDeleteDB.ExecuteNonQuery();
						conNewsData.Close();
				}
				else if (slctCheckBox.Checked & SelectedAction=="Block IP") {
				}
        }
		
		conNewsData = new OleDbConnection( "PROVIDER=Microsoft.Jet.OLEDB.4.0;DATA Source=" + Server.MapPath("../NewsData.mdb") );
		string MaxComment = "SELECT MAX(CommentNumber) from CommentData WHERE CommentId= @CommentId";
		OleDbCommand cmdCommentNumber = new OleDbCommand( MaxComment, conNewsData );
		cmdCommentNumber.Parameters.Add(new OleDbParameter("@CommentId", Request.QueryString.Get("Edit")));
		conNewsData.Open();
		Object objMax = cmdCommentNumber.ExecuteScalar();
		if (objMax != DBNull.Value) {
			comNumber = objMax.ToString();
			}
		else {
			comNumber = "0"; 
			}
		conNewsData.Close();
		
		string TotalComment = "SELECT Count(CommentNumber) from CommentData WHERE CommentId= @CommentId";
		OleDbCommand cmdCommentTotal = new OleDbCommand( TotalComment, conNewsData );
		cmdCommentTotal.Parameters.Add(new OleDbParameter("@CommentId", Request.QueryString.Get("Edit")));
		conNewsData.Open();
		Object objTotal = cmdCommentTotal.ExecuteScalar();
		comTotal = objTotal.ToString();
		conNewsData.Close();
				
		string strUpdate = "UPDATE ArticleData SET ArticleComments = @Total WHERE ArticleId = @ArticleId";
		OleDbCommand cmdCount = new OleDbCommand( strUpdate, conNewsData );
		cmdCount.Parameters.Add(new OleDbParameter("@Total", comTotal));
		cmdCount.Parameters.Add(new OleDbParameter("@ArticleId", Request.QueryString.Get("Edit")));
		conNewsData.Open();
		cmdCount.ExecuteNonQuery();
		conNewsData.Close();
		
		string ArticleName = "SELECT ArticleName from ArticleData where ArticleId = @ArticleId";
		OleDbCommand cmdReadArticleName = new OleDbCommand( ArticleName, conNewsData );
		cmdReadArticleName.Parameters.Add(new OleDbParameter("@ArticleId", Request.QueryString.Get("Edit")));
		conNewsData.Open();
		Object objArticleName = cmdReadArticleName.ExecuteScalar();
		artName = objArticleName.ToString();
		conNewsData.Close();
		
		
		string LastComment = "SELECT CommentUserName from CommentData where CommentNumber = @CommentNumber AND CommentId = @CommentId";
		OleDbCommand cmdReadCommentDB = new OleDbCommand( LastComment, conNewsData );
		cmdReadCommentDB.Parameters.Add(new OleDbParameter("@CommentNumber", comNumber));
		cmdReadCommentDB.Parameters.Add(new OleDbParameter("@CommentId", Request.QueryString.Get("Edit")));
		conNewsData.Open();
		Object objLastComment = cmdReadCommentDB.ExecuteScalar();
		conNewsData.Close();
		
		if (comTotal != "0") {
			artLastUser = "<a href='./Comments.aspx?ArticleId=" +  Request.QueryString.Get("Edit").ToString() + "&amp;ArticleName=" + artName + "#" + comTotal + "' class='ContentFooter'>Last comment</a> was by <a class='ContentFooterUser' href='#'>" + objLastComment.ToString() + "</a>";
		}
		else {
		artLastUser = "<a class='ContentFooter' href='./Comments.aspx?ArticleId=" + Request.QueryString.Get("Edit").ToString() + "&amp;ArticleName=" + artName + "'>Be the First to Submit a Comment</a>";
		}
		
		
		string strUpdateLastUser = "UPDATE ArticleData SET LastComment = @LastUser WHERE ArticleId = @ArticleId";
		OleDbCommand cmdUpdateLastUserDB = new OleDbCommand( strUpdateLastUser, conNewsData );
		cmdUpdateLastUserDB.Parameters.Add(new OleDbParameter("@LastUser", artLastUser));
		cmdUpdateLastUserDB.Parameters.Add(new OleDbParameter("@ArticleId", Request.QueryString.Get("Edit")));
		conNewsData.Open();
		cmdUpdateLastUserDB.ExecuteNonQuery();
		conNewsData.Close();
		
		Response.Redirect(Request.UrlReferrer.ToString());
}  

}